use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Differences;
use Test::More;
use Test::Exception;
use qbit;

run_tests(
    sub {
        my ($app) = @_;

        no warnings 'redefine';
        no strict 'refs';

        *{'LWP::UserAgent::request'} = sub {
            my ($mock, $request) = @_;
            my $url = $request->uri;

            my $fake_data = {
                "total_rows" => 2,
                "data"       => [
                    {
                        "metrics" => ["2"],
                        "dimensions" =>
                          [{"name" => "2016-07-19"}, {"name" => "4444"}, {"name" => "organic"}, {"name" => "view"}]
                    },
                    {
                        "metrics"    => ["1"],
                        "dimensions" => [
                            {"name" => "2016-07-20"},
                            {"name" => "55555"},
                            {"name" => "commercial"},
                            {"name" => "open_player"}
                        ]
                    },
                ],
            };

            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());
            $r->content(to_json($fake_data));

            if ($url =~ m#stat/v1/data.*722884#) {
                *{'HTTP::Response::decoded_content'} = sub {
                    return to_json($fake_data);
                };
            } elsif ($url =~ m#stat/v1/data.*833995#) {
                *{'HTTP::Response::decoded_content'} = sub {
                    $fake_data->{total_rows} = 100001;
                    delete $fake_data->{data}->[1];
                    $fake_data->{data}->[0]->{metrics}->[0] = '1';
                    $fake_data->{data}->[0]->{dimensions}->[2]->{name} = '666666';
                    return to_json($fake_data);
                };
            }

            return $r;
        };

        $app->set_option(
            api_metrika => {
                url         => 'http://api-metrika',
                token       => 'secret',
                counter_id  => '722884',
                filter_name => 'statistics_video_an_site_page',
            }
        );

        eq_or_diff(
            to_json($app->api_metrika->get_stat('2016-07-19', '2016-07-20'), pretty => 1),
            to_json(
                [
                    {
                        date          => '2016-07-19',
                        page_id       => '4444',
                        position_type => 'organic',
                        pixel_type    => 'view',
                        total         => '2',
                    },
                    {
                        date          => '2016-07-20',
                        page_id       => '55555',
                        position_type => 'commercial',
                        pixel_type    => 'open_player',
                        total         => '1',
                    },
                ],
                pretty => 1,
            ),
            'Smoke API Metrika get_stat check'
        );

        $app->set_option(
            api_metrika => {
                url         => 'http://api-metrika',
                token       => 'secret',
                counter_id  => '833995',
                filter_name => 'statistics_video_an_site_page',
            }
        );

        throws_ok {$app->api_metrika->get_stat('2016-07-19', '2016-07-19')}
        qr/Answer from Metrika contains amount of rows over requested limit/,
          'Smoke API Metrika get_stat total_rows limit check';
    },
    dont_create_database => 1,
);
