#!/usr/bin/perl

use Test::Differences qw(eq_or_diff);

use qbit;

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);

run_tests(
    sub {
        my ($app) = @_;

        delete($Test::Partner2::Mock::original_subs->{'LWP::UserAgent::request'});

        my $status;
        mock_subs(
            {
                'LWP::UserAgent::request' => sub {
                    my ($mock, $request) = @_;

                    my $r = HTTP::Response->new($status // 200);

                    $r->request($request);
                    $r->content('');

                    return $r;
                  }
            }
        );

        my $tests = get_test_data_and_update_if_needed('data.json');

        my @data = ();
        foreach my $test (@$tests) {
            $status = $test->{'status'};
            my $result = \0;
            my $error;
            try {
                $app->api_solomon->send(%{$test->{'opts'}});
                $result = \1;
            }
            catch {
                my $message = shift->message();
                $error = eval {from_json($message)} || $message;
            };

            push(
                @data,
                {
                    name   => $test->{'name'},
                    opts   => $test->{'opts'},
                    result => $result,
                    ($status ? (status => $status) : ()),
                    ($error  ? (error  => $error)  : ()),
                }
            );
        }

        get_test_data_and_update_if_needed('data.json', \@data);

        eq_or_diff(to_json(\@data, pretty => TRUE), to_json($tests, pretty => TRUE), "Check");
    },
    dont_create_database => TRUE,
    init                 => [qw(api_solomon)],
);
