use strict;
use warnings FATAL => 'all';

use Test::Differences;
use Test::More;
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use qbit;
use DDP;

run_tests(
    sub {
        my ($app) = @_;

        my ($execute, $read_table);
        my_mocks(\$execute, \$read_table);

        my $cases = [
            {
                Data       => [],
                read_table => undef,
            },
            {
                Data => [
                    [
                        [1478463],
                        [
"{\"PageID\":\"1478463\",\"Options\":\"\",\"DirectBlocks\":{},\"Domain\":\"sayrozhd.turbo.site\",\"State\":\"0\",\"Mirrors\":\"\",\"PartnerID\":\"31190512\",\"Places\":\"\",\"TargetType\":\"8\",\"PPCTotal\":\"9\",\"RtbBlocks\":{},\"IsYandexPage\":\"0\",\"Name\":\"406656-2539402\"}"
                        ],
                    ]
                ],
                Ref        => undef,
                read_table => undef,
            },
            {
                Data => [
                    [
                        [1478463],
                        [
"{\"PageID\":\"1478463\",\"Options\":\"\",\"DirectBlocks\":{},\"Domain\":\"sayrozhd.turbo.site\",\"State\":\"0\",\"Mirrors\":\"\",\"PartnerID\":\"31190512\",\"Places\":\"\",\"TargetType\":\"8\",\"PPCTotal\":\"9\",\"RtbBlocks\":{},\"IsYandexPage\":\"0\",\"Name\":\"406656-2539402\"}"
                        ],
                    ]
                ],
                Ref => [
                    {
                        Reference => ['yt',     'harn', 'path/to'],
                        Columns   => ['PageID', 'Data'],
                    }
                ],
                read_table =>
qq({\"PageID\":667830,\"Data\":{\"PageID\":\"1478463\",\"Options\":\"\",\"DirectBlocks\":{},\"Domain\":\"sayrozhd.turbo.site\",\"State\":\"0\",\"Mirrors\":\"\",\"PartnerID\":\"31190512\",\"Places\":\"\",\"TargetType\":\"8\",\"PPCTotal\":\"9\",\"RtbBlocks\":{},\"IsYandexPage\":\"0\",\"Name\":\"406656-2539402\"}}),
            },
        ];

        for my $case (@$cases) {
            $execute    = get_execute_response($case);
            $read_table = $case->{read_table};

            $case->{result} = $app->api_yql->_yql_get_operation_result('operation_id', want_result => TRUE);
        }
        my $expected = get_test_data_and_update_if_needed('data.json', $cases);
        eq_or_diff($cases, $expected, "_yql_get_operation_result", {context => 1});
    },
    init => [qw(api_yql)],
);

sub get_execute_response {
    my ($case) = @_;

    my $template = {
        data => [
            {
                Write => [
                    {
                        Data => [],
                        Type => [
                            'ListType',
                            [
                                'StructType',
                                [
                                    ['PageID', ['OptionalType', ['DataType', 'Int64',]]],
                                    ['Data',   ['OptionalType', ['DataType', 'String',]]],
                                ]
                            ]
                        ],
                    }
                ],
            }
        ]
    };

    my $write = $template->{data}[0]{Write};
    $write->[0]{Data} = $case->{Data};
    $write->[0]{Ref} = $case->{Ref} if $case->{Ref};

    return to_json($template, canonical => TRUE);
}

sub my_mocks {
    my ($execute, $read_table) = @_;
    mock_subs(
        {
            'QBit::Application::Model::API::Yandex::YQL::_yql_wait_operation' => sub {TRUE},
            'QBit::Application::Model::API::Yandex::YQL::_execute'            => sub {
                return $$execute;
            },
            'QBit::Application::Model::API::Yandex::YT::read_table' => sub {
                return $$read_table;
            },
        }
    );
}
