use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Differences;

use Test::Partner::Utils;
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);

use qbit;

run_tests(
    sub {
        my ($app) = @_;
        my @result;
        mock_subs(
            {
                'QBit::Application::Model::API::HTTP::request' => sub {
                    my ($self, %params) = @_;
                    if ($params{need_response}) {
                        push @result, \%params;
                        my $response =
                          HTTP::Response->new(@{get_test_data_and_update_if_needed('avito-response.json', undef)});
                        $response->request(HTTP::Request->new(GET => $params{uri}));
                        return $response;
                    } else {
                        $params{content} = from_json($params{content});
                        push @result, \%params;
                        return get_test_data_and_update_if_needed('avito.json', undef, raw => 1);
                    }
                },
                'Application::Model::API::Yandex::TVM::get_service_ticket' => sub {
                    return "3:serv:CPlMEP";
                },
            }
        );
        my $zora = $app->api_http_gozora->get_page_inf(
            page_url => 'http://www.avito.ru',
            timeout  => 60,
        );
        push @result, $zora;

        # форсируем поход через GoZora
        $app->kv_store->set(enable_gozora => 1);
        my $gozora = $app->api_http_gozora->get_page_inf(
            page_url => 'http://www.avito.ru',
            timeout  => 60,
        );
        push @result, $gozora;

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $has, 'body');
    },
    init => ['api_http_gozora', 'api_tvm'],
);
