use strict;
use warnings FATAL => 'all';

use Test::More;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);

use qbit;

my $url_timeout = 60;

my $test_data = [
    {
        test_name  => 'Normal url is gotten.',
        domain     => 'qiwi.ru',
        is_working => TRUE,
        status     => 200,
    },
    {
        test_name  => 'Normal url is gotten with meta-tag "noindex".',
        domain     => 'noindex.ru',
        is_working => TRUE,
        status     => 2005,
    },
    {
        test_name  => 'Dead url is gotten.',
        domain     => 'dead',
        is_working => FALSE,
        status     => 1006,
    },
];

run_tests(
    sub {
        my ($app) = @_;

        no warnings 'redefine';
        no strict 'refs';

        mock_subs(
            {
                'QBit::Application::Model::API::Yandex::HTTPGoZora::get_page_inf' => sub {
                    my ($self, %opts) = @_;

                    my $domain = $opts{page_url};

                    my $body_length_bytes = $domain =~ /dead/ ? 0 : 1;
                    my $status = 200;

                    foreach my $data (@$test_data) {
                        $status = $data->{status}
                          if $data->{domain} eq $domain;
                    }

                    my $effective_url = "http://$domain";

                    return {
                        "body_length_bytes" => $body_length_bytes,
                        "robots_ok"         => \1,
                        "domain"            => "$domain",
                        "effective_url"     => "$effective_url",
                        "status"            => $status
                    };
                },
            }
        );

        is($app->api_http_gozora->is_site_working($_->{domain}), $_->{is_working}, $_->{test_name}) foreach @$test_data;
    },
    dont_create_database => 1,
    init                 => ['api_http_gozora'],
);
