#!/usr/bin/perl

use qbit;

use Test::More tests => 2;
use Test::Differences;

use TestAppDB;

my $NAME = '';
my $SQL  = '';

my $FIXTURES = [
    {
        name   => 'disable keys',
        params => {disable_keys => TRUE},
        sql    => 'ALTER TABLE
    "table1"
DISABLE KEYS
',
    },
    {
        name   => 'enable keys',
        params => {enable_keys => TRUE},
        sql    => 'ALTER TABLE
    "table1"
ENABLE KEYS
',
    },
];

main();

sub main {
    my $app = TestAppDB->new();

    $app->pre_run();

    $app->db;

    {
        no strict 'refs';
        no warnings 'redefine';

        *{'QBit::Application::Model::DB::_do'} = sub {
            eq_or_diff($_[1], $SQL, $NAME);
        };
    }

    my $params;
    foreach (@$FIXTURES) {
        ($NAME, $params, $SQL) = @$_{qw(name params sql)};

        $app->db->table1->alter(%$params);
    }

    $app->post_run();
}
