#!/usr/bin/perl

use qbit;

use Test::More tests => 5;

use QBit::Application::Model::DB::clickhouse::String;

my $FIXTURES = [
    {param => 'abc',  value => "'abc'"},
    {param => 3,      value => "'3'"},
    {param => undef,  value => "NULL"},
    {param => "a'b",  value => "'a\\'b'"},
    {param => 'a\\b', value => "'a\\\\b'"},
];

main();

sub main {
    foreach (@$FIXTURES) {
        is(QBit::Application::Model::DB::clickhouse::String->new($_->{'param'})->value,
            $_->{'value'}, 'param: ' . ($_->{'param'} // 'undef'));
    }
}
