#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Most tests => 6;
use Test::Deep qw(cmp_deeply);
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Mock qw(mock_subs);

use qbit;

use TestAppDB;

my $app = TestAppDB->new();

$app->pre_run();

$app->set_option(
    'locales' => {
        "en" => {"code" => "en_GB", "domain"  => "yandex.com", "name"   => "English"},
        "ru" => {"code" => "ru_RU", "default" => 1,            "domain" => "yandex.ru", "name" => "Русский"}
    }
);

$app->mysql_db->_connect;

my $SQL;
my $DATA;

mock_subs(
    {
        'QBit::Application::Model::DB::_do' => sub {
            shift;
            my $sql = shift;
            eq_or_diff($sql, $SQL, 'SQL');

            cmp_deeply(\@_, $DATA, 'Data');
        },
        'DBI::db::prepare' => sub {
            eq_or_diff($_[1], $SQL, 'SQL in prepare');

            return $Test::Partner2::Mock::original_subs->{'DBI::db::prepare'}->(@_);
        },
        'DBI::st::execute' => sub {
            shift;
            cmp_deeply(\@_, $DATA, 'Data in execute');

            return TRUE;
        },
    }
);

$SQL = qq{INSERT INTO "table" ("field", "field_i18n_en", "field_i18n_ru", "field_str") VALUES
(?, ?, ?, ?),
(?, ?, ?, ?)};

$DATA = [1, 'all', 'all', 'test', 2, 'all 2', 'all 2', 'test 2'];

$app->mysql_db->table->add_multi(
    [
        {
            field      => 1,
            field_str  => 'test',
            field_i18n => 'all'
        },
        {
            field      => 2,
            field_str  => 'test 2',
            field_i18n => 'all 2'
        },
    ]
);

$SQL = qq{INSERT INTO "table" ("field", "field_i18n_en", "field_i18n_ru", "field_str") VALUES
(?, ?, ?, ?),
(?, ?, ?, ?)};

$DATA = [1, 'en', 'ru', 'test', 2, 'en 2', 'ru 2', 'test 2'];

$app->mysql_db->table->add_multi(
    [
        {
            field      => 1,
            field_str  => 'test',
            field_i18n => {ru => 'ru', en => 'en'}
        },
        {
            field      => 2,
            field_str  => 'test 2',
            field_i18n => {ru => 'ru 2', en => 'en 2'}
        },
    ]
);

$SQL = qq{INSERT INTO "table" ("field", "field_i18n_en", "field_i18n_ru", "field_str", "id") SELECT
    "table"."field" AS "field",
    "table"."field_i18n_en" AS "field_i18n_en",
    "table"."field_i18n_ru" AS "field_i18n_ru",
    "table"."field_str" AS "field_str",
    "table"."id" AS "id"
FROM "table"
WHERE (
    "table"."id" = '3'
)};

$DATA = [];

$app->mysql_db->table->add_multi(
    [
        $app->mysql_db->query->select(
            table  => $app->mysql_db->table,
            fields => [qw(id field field_str field_i18n)],
            filter => {id => 3}
          )->all_langs(TRUE)
    ]
);

$app->post_run();
