#!/usr/bin/perl

use qbit;

use Test::More tests => 2;
use Test::Differences;

use TestAppDB;

BEGIN {
    *CORE::GLOBAL::time = sub {1536152621};
}

local $$ = 100_500;

my $SQL = 'RENAME TABLE "table1" TO "table1_100500_1536152621",
    "table2" TO "table1",
    "table1_100500_1536152621" TO "table2"';

my $NAME = '';

main();

sub main {
    my $app = TestAppDB->new();

    $app->pre_run();

    $app->db;

    {
        no strict 'refs';
        no warnings 'redefine';

        *{'QBit::Application::Model::DB::_do'} = sub {
            eq_or_diff($_[1], $SQL, $NAME);
        };
    }

    $NAME = 'table name as string';
    $app->db->table1->swap('table2');

    $NAME = 'table name as object';
    $app->db->table1->swap($app->db->table2);

    $app->post_run();
}
