#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        #create new filters
        $app->context_on_site_rtb->model_filter(
            {
                db_accessor => 'partner_db',
                fields      => {
                    campaign_id => {type => 'number', label => d_gettext('Page ID')},
                    campaign    => {
                        type           => 'subfilter',
                        model_accessor => 'page',
                        field          => 'campaign_id',
                        fk_field       => 'page_id',
                        label          => d_gettext('Campaign'),
                    },
                    page_id => {type => 'alias', path => [qw(campaign_id)]},
                    login   => {type => 'alias', path => [qw(campaign owner login)]},
                }
            }
        );

        my $db_filter_fields = $app->context_on_site_rtb->get_db_filter_fields(fields => [qw(page_id login)]);
        delete(@$db_filter_fields{qw(campaign_id campaign)});

        cmp_deeply(
            $db_filter_fields,
            {
                'login' => {
                    'label' => 'Login',
                    'type'  => 'login'
                },
                'page_id' => {
                    'label' => 'Page ID',
                    'type'  => 'number'
                }
            },
            'get_db_filter_fields'
        );

        cmp_deeply(
            $app->context_on_site_rtb->get_db_filter(['page_id', '=', 12345])->expression,
            ['AND', [['campaign_id', '=', \12345]]],
            'get_db_filter for simple filter'
        );

        my $filter = $app->context_on_site_rtb->get_db_filter(['login', '=', 'yndx-login'])->expression;

        cmp_deeply($filter->[1][0][2], isa('QBit::Application::Model::DB::Query'));
        ($filter->[1][0][2]) = $filter->[1][0][2]->get_sql_with_data;

        cmp_deeply(
            $filter,
            [
                'AND',
                [
                    [
                        'campaign_id',
                        '= ANY',
                        'SELECT
    `context_on_site_campaign`.`page_id` AS `page_id`
FROM `context_on_site_campaign`
WHERE (
    `context_on_site_campaign`.`owner_id` = ANY (
        SELECT
            `users`.`id` AS `id`
        FROM `users`
        WHERE (
            `users`.`login` = \'yndx-login\'
        )
    )
)'
                    ]
                ]
            ],
            'get_db_filter for subfilter'
        );
    },
);
