#!/usr/bin/perl

use Test::Most;
use Test::More;

use qbit;

my $OPERATORS =
  ['>', '>=', '<', '<=', 'IS', 'IS NOT', 'LIKE', 'NOT LIKE', '=', '<>', 'IN', 'NOT IN', 'MATCH', 'NOT MATCH'];

my $DATA = [
    undef, -1, 1, '', 'text', '2017-01-14', '2017-01-14 15:21:57',
    '14/01/2017', 'tomorrow', [], [1], ['text'], {key => 'val'},
    JSON::XS::true, JSON::XS::false,
];

my $RESULT = {
    boolean => {
        '["name","=",null]'                  => TRUE,
        '["name","=",-1]'                    => TRUE,
        '["name","=",1]'                     => TRUE,
        '["name","=",""]'                    => TRUE,
        '["name","=","text"]'                => TRUE,
        '["name","=","2017-01-14"]'          => TRUE,
        '["name","=","2017-01-14 15:21:57"]' => TRUE,
        '["name","=","14/01/2017"]'          => TRUE,
        '["name","=","tomorrow"]'            => TRUE,
        '["name","=",true]'                  => TRUE,
        '["name","=",false]'                 => TRUE,
    },
    contractnumber => {
        # use looks_like_number?
        '["name","=",null]'                  => TRUE,
        '["name","=",-1]'                    => TRUE,
        '["name","=",1]'                     => TRUE,
        '["name","=",""]'                    => TRUE,
        '["name","=","text"]'                => TRUE,
        '["name","=",[]]'                    => TRUE,
        '["name","=",[1]]'                   => TRUE,
        '["name","=",["text"]]'              => TRUE,
        '["name","IN",[]]'                   => TRUE,
        '["name","IN",[1]]'                  => TRUE,
        '["name","IN",["text"]]'             => TRUE,
        '["name","=","2017-01-14"]'          => TRUE,
        '["name","=","2017-01-14 15:21:57"]' => TRUE,
        '["name","=","14/01/2017"]'          => TRUE,
        '["name","=","tomorrow"]'            => TRUE,
    },
    date => {
        '["name",">","2017-01-14"]'           => TRUE,
        '["name",">","2017-01-14 15:21:57"]'  => TRUE,
        '["name",">=","2017-01-14"]'          => TRUE,
        '["name",">=","2017-01-14 15:21:57"]' => TRUE,
        '["name","<","2017-01-14"]'           => TRUE,
        '["name","<","2017-01-14 15:21:57"]'  => TRUE,
        '["name","<=","2017-01-14"]'          => TRUE,
        '["name","<=","2017-01-14 15:21:57"]' => TRUE,
        '["name","=","2017-01-14"]'           => TRUE,
        '["name","=","2017-01-14 15:21:57"]'  => TRUE,
        '["name","<>","2017-01-14"]'          => TRUE,
        '["name","<>","2017-01-14 15:21:57"]' => TRUE,
    },
    dictionary => {
        #check value list?
        '["name","IS",null]'                  => TRUE,
        '["name","IS NOT",null]'              => TRUE,
        '["name","=",null]'                   => TRUE,
        '["name","=",-1]'                     => TRUE,
        '["name","=",1]'                      => TRUE,
        '["name","=",""]'                     => TRUE,
        '["name","=","text"]'                 => TRUE,
        '["name","=",[]]'                     => TRUE,
        '["name","=",[1]]'                    => TRUE,
        '["name","=",["text"]]'               => TRUE,
        '["name","=","2017-01-14"]'           => TRUE,
        '["name","=","2017-01-14 15:21:57"]'  => TRUE,
        '["name","=","14/01/2017"]'           => TRUE,
        '["name","=","tomorrow"]'             => TRUE,
        '["name","<>",null]'                  => TRUE,
        '["name","<>",-1]'                    => TRUE,
        '["name","<>",1]'                     => TRUE,
        '["name","<>",""]'                    => TRUE,
        '["name","<>","text"]'                => TRUE,
        '["name","<>",[]]'                    => TRUE,
        '["name","<>",[1]]'                   => TRUE,
        '["name","<>",["text"]]'              => TRUE,
        '["name","<>","2017-01-14"]'          => TRUE,
        '["name","<>","2017-01-14 15:21:57"]' => TRUE,
        '["name","<>","14/01/2017"]'          => TRUE,
        '["name","<>","tomorrow"]'            => TRUE,
    },
    multistate => {
        '["name","=",null]'                   => FALSE,
        '["name","=",-1]'                     => FALSE,
        '["name","=",1]'                      => TRUE,
        '["name","=","text"]'                 => TRUE,
        '["name","=",[]]'                     => TRUE,
        '["name","=",[1]]'                    => TRUE,
        '["name","=",""]'                     => FALSE,
        '["name","=",["text"]]'               => TRUE,
        '["name","=","2017-01-14"]'           => FALSE,
        '["name","=","2017-01-14 15:21:57"]'  => FALSE,
        '["name","=","14/01/2017"]'           => FALSE,
        '["name","=","tomorrow"]'             => TRUE,
        '["name","<>",null]'                  => FALSE,
        '["name","<>",-1]'                    => FALSE,
        '["name","<>",1]'                     => TRUE,
        '["name","<>",""]'                    => FALSE,
        '["name","<>","text"]'                => TRUE,
        '["name","<>",[]]'                    => TRUE,
        '["name","<>",[1]]'                   => TRUE,
        '["name","<>",["text"]]'              => TRUE,
        '["name","<>","2017-01-14"]'          => FALSE,
        '["name","<>","2017-01-14 15:21:57"]' => FALSE,
        '["name","<>","14/01/2017"]'          => FALSE,
        '["name","<>","tomorrow"]'            => TRUE,
    },
    number => {
        # use looks_like_number?
        '["name",">",null]'                   => TRUE,
        '["name",">",-1]'                     => TRUE,
        '["name",">",1]'                      => TRUE,
        '["name",">",""]'                     => TRUE,
        '["name",">","text"]'                 => TRUE,
        '["name",">","2017-01-14"]'           => TRUE,
        '["name",">","2017-01-14 15:21:57"]'  => TRUE,
        '["name",">","14/01/2017"]'           => TRUE,
        '["name",">","tomorrow"]'             => TRUE,
        '["name",">=",null]'                  => TRUE,
        '["name",">=",-1]'                    => TRUE,
        '["name",">=",1]'                     => TRUE,
        '["name",">=",""]'                    => TRUE,
        '["name",">=","text"]'                => TRUE,
        '["name",">=","2017-01-14"]'          => TRUE,
        '["name",">=","2017-01-14 15:21:57"]' => TRUE,
        '["name",">=","14/01/2017"]'          => TRUE,
        '["name",">=","tomorrow"]'            => TRUE,
        '["name","<",null]'                   => TRUE,
        '["name","<",-1]'                     => TRUE,
        '["name","<",1]'                      => TRUE,
        '["name","<",""]'                     => TRUE,
        '["name","<","text"]'                 => TRUE,
        '["name","<","2017-01-14"]'           => TRUE,
        '["name","<","2017-01-14 15:21:57"]'  => TRUE,
        '["name","<","14/01/2017"]'           => TRUE,
        '["name","<","tomorrow"]'             => TRUE,
        '["name","<=",null]'                  => TRUE,
        '["name","<=",-1]'                    => TRUE,
        '["name","<=",1]'                     => TRUE,
        '["name","<=",""]'                    => TRUE,
        '["name","<=","text"]'                => TRUE,
        '["name","<=","2017-01-14"]'          => TRUE,
        '["name","<=","2017-01-14 15:21:57"]' => TRUE,
        '["name","<=","14/01/2017"]'          => TRUE,
        '["name","<=","tomorrow"]'            => TRUE,
        '["name","IS",null]'                  => TRUE,
        '["name","IS NOT",null]'              => TRUE,
        '["name","=",null]'                   => TRUE,
        '["name","=",-1]'                     => TRUE,
        '["name","=",1]'                      => TRUE,
        '["name","=",""]'                     => TRUE,
        '["name","=","text"]'                 => TRUE,
        '["name","=",[]]'                     => TRUE,
        '["name","=",[1]]'                    => TRUE,
        '["name","=",""]'                     => TRUE,
        '["name","=",["text"]]'               => TRUE,
        '["name","=","2017-01-14"]'           => TRUE,
        '["name","=","2017-01-14 15:21:57"]'  => TRUE,
        '["name","=","14/01/2017"]'           => TRUE,
        '["name","=","tomorrow"]'             => TRUE,
        '["name","<>",null]'                  => TRUE,
        '["name","<>",-1]'                    => TRUE,
        '["name","<>",1]'                     => TRUE,
        '["name","<>",""]'                    => TRUE,
        '["name","<>","text"]'                => TRUE,
        '["name","<>",[]]'                    => TRUE,
        '["name","<>",[1]]'                   => TRUE,
        '["name","<>",""]'                    => TRUE,
        '["name","<>",["text"]]'              => TRUE,
        '["name","<>","2017-01-14"]'          => TRUE,
        '["name","<>","2017-01-14 15:21:57"]' => TRUE,
        '["name","<>","14/01/2017"]'          => TRUE,
        '["name","<>","tomorrow"]'            => TRUE,
        '["name","IN",[]]'                    => TRUE,
        '["name","IN",[1]]'                   => TRUE,
        '["name","IN",["text"]]'              => TRUE,
        '["name","NOT IN",[]]'                => TRUE,
        '["name","NOT IN",[1]]'               => TRUE,
        '["name","NOT IN",["text"]]'          => TRUE,
    },
    period   => {'["name","=","tomorrow"]' => TRUE,},
    publicid => {
        '["name","=",null]'                   => TRUE,
        '["name","=",-1]'                     => TRUE,
        '["name","=",1]'                      => TRUE,
        '["name","=",""]'                     => TRUE,
        '["name","=","text"]'                 => TRUE,
        '["name","=",[]]'                     => TRUE,
        '["name","=",[1]]'                    => TRUE,
        '["name","=",""]'                     => TRUE,
        '["name","=",["text"]]'               => TRUE,
        '["name","=","2017-01-14"]'           => TRUE,
        '["name","=","2017-01-14 15:21:57"]'  => TRUE,
        '["name","=","14/01/2017"]'           => TRUE,
        '["name","=","tomorrow"]'             => TRUE,
        '["name","<>",null]'                  => TRUE,
        '["name","<>",-1]'                    => TRUE,
        '["name","<>",1]'                     => TRUE,
        '["name","<>",""]'                    => TRUE,
        '["name","<>","text"]'                => TRUE,
        '["name","<>",[]]'                    => TRUE,
        '["name","<>",[1]]'                   => TRUE,
        '["name","<>",""]'                    => TRUE,
        '["name","<>",["text"]]'              => TRUE,
        '["name","<>","2017-01-14"]'          => TRUE,
        '["name","<>","2017-01-14 15:21:57"]' => TRUE,
        '["name","<>","14/01/2017"]'          => TRUE,
        '["name","<>","tomorrow"]'            => TRUE,
        '["name","IN",[]]'                    => TRUE,
        '["name","IN",[1]]'                   => TRUE,
        '["name","IN",["text"]]'              => TRUE,
        '["name","NOT IN",[]]'                => TRUE,
        '["name","NOT IN",[1]]'               => TRUE,
        '["name","NOT IN",["text"]]'          => TRUE,
    },
    subfilter => {
        '["name","MATCH",[]]'           => TRUE,
        '["name","MATCH",[1]]'          => TRUE,
        '["name","MATCH",["text"]]'     => TRUE,
        '["name","NOT MATCH",[]]'       => TRUE,
        '["name","NOT MATCH",[1]]'      => TRUE,
        '["name","NOT MATCH",["text"]]' => TRUE,
    },
    text => {
        '["name","IS",null]'                        => TRUE,
        '["name","IS NOT",null]'                    => TRUE,
        '["name","LIKE",null]'                      => TRUE,
        '["name","LIKE",-1]'                        => TRUE,
        '["name","LIKE",1]'                         => TRUE,
        '["name","LIKE",""]'                        => TRUE,
        '["name","LIKE","text"]'                    => TRUE,
        '["name","LIKE","2017-01-14"]'              => TRUE,
        '["name","LIKE","2017-01-14 15:21:57"]'     => TRUE,
        '["name","LIKE","14/01/2017"]'              => TRUE,
        '["name","LIKE","tomorrow"]'                => TRUE,
        '["name","NOT LIKE",null]'                  => TRUE,
        '["name","NOT LIKE",-1]'                    => TRUE,
        '["name","NOT LIKE",1]'                     => TRUE,
        '["name","NOT LIKE",""]'                    => TRUE,
        '["name","NOT LIKE","text"]'                => TRUE,
        '["name","NOT LIKE","2017-01-14"]'          => TRUE,
        '["name","NOT LIKE","2017-01-14 15:21:57"]' => TRUE,
        '["name","NOT LIKE","14/01/2017"]'          => TRUE,
        '["name","NOT LIKE","tomorrow"]'            => TRUE,
        '["name","=",null]'                         => TRUE,
        '["name","=",-1]'                           => TRUE,
        '["name","=",1]'                            => TRUE,
        '["name","=",""]'                           => TRUE,
        '["name","=","text"]'                       => TRUE,
        '["name","=",[]]'                           => TRUE,
        '["name","=",[1]]'                          => TRUE,
        '["name","=",""]'                           => TRUE,
        '["name","=",["text"]]'                     => TRUE,
        '["name","=","2017-01-14"]'                 => TRUE,
        '["name","=","2017-01-14 15:21:57"]'        => TRUE,
        '["name","=","14/01/2017"]'                 => TRUE,
        '["name","=","tomorrow"]'                   => TRUE,
        '["name","<>",null]'                        => TRUE,
        '["name","<>",-1]'                          => TRUE,
        '["name","<>",1]'                           => TRUE,
        '["name","<>",""]'                          => TRUE,
        '["name","<>","text"]'                      => TRUE,
        '["name","<>",[]]'                          => TRUE,
        '["name","<>",[1]]'                         => TRUE,
        '["name","<>",""]'                          => TRUE,
        '["name","<>",["text"]]'                    => TRUE,
        '["name","<>","2017-01-14"]'                => TRUE,
        '["name","<>","2017-01-14 15:21:57"]'       => TRUE,
        '["name","<>","14/01/2017"]'                => TRUE,
        '["name","<>","tomorrow"]'                  => TRUE,
        '["name","IN",[]]'                          => TRUE,
        '["name","IN",[1]]'                         => TRUE,
        '["name","IN",["text"]]'                    => TRUE,
        '["name","NOT IN",[]]'                      => TRUE,
        '["name","NOT IN",[1]]'                     => TRUE,
        '["name","NOT IN",["text"]]'                => TRUE,
    },
};

foreach my $type (qw(boolean contractnumber date dictionary multistate number period publicid subfilter text)) {
    my $package = "QBit::Application::Model::DBManager::Filter::$type";

    require_ok($package);

    my $filter_obj = $package->new();

    foreach my $op (@$OPERATORS) {
        foreach my $d (@$DATA) {
            my $filter = ['name', $op, $d];
            my $name = to_json($filter);

            my $err = 0;
            try {
                $filter_obj->check($filter, {type => $type});
            }
            catch {
                $err = 1;
            };

            ok($RESULT->{$type}{$name} ? !$err : $err,
                to_json($filter) . ' - ' . ($RESULT->{$type}{$name} ? 'correct' : 'incorrect'));
        }
    }
}

done_testing();
