use strict;
use warnings FATAL => 'all';

use Test::More tests => 1;
use Test::Deep;
use Test::MockObject;

use qbit;

use Test::Partner2::Simple;

use QBit::Application::Model::DBManager::_Utils::Fields;

eval {
    package TestModel;
    sub get_opts_schema_name {'test_schema_name'}
    1;
} or die $@;

my $fields = {
    from_hash_field => {from_opts => 'from_hash',},
    db_expr_field   => {from_opts => 'db_expr',},
    db_generated    => {from_opts => 'db_generated',},
    regular_fields  => {
        db      => 1,
        db_expr => ['AND' => [\0, \1]],
        need_check => {type => 'boolean',},
        type       => 'boolean',
    },
};

QBit::Application::Model::DBManager::_Utils::Fields::_init_opts_fields('TestModel', $fields);

my $expected = {
    'db_expr_field' => {
        'from_opts' => 'db_expr',
        'db_expr'   => ['opts', '->', \'$.db_expr_field'],
        'db'        => 1,
        'get'       => ignore()
    },
    'opts' => {
        'db'       => 1,
        'get'      => ignore(),
        'type'     => 'complex',
        need_check => {type => 'ref', optional => 1}
    },
    'regular_fields' => {
        'db_expr' => ['AND', [\0, \1]],
        'db'      => 1,
        'type'    => 'boolean',
        'need_check' => {'type' => 'boolean'}
    },
    'from_hash_field' => {
        'from_opts'  => 'from_hash',
        'get'        => ignore(),
        'depends_on' => ['opts']
    },
    'db_generated' => {
        'from_opts'    => 'db_generated',
        'get'          => ignore(),
        'db_generated' => 1
    }
};

cmp_deeply($fields, $expected);
