use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Deep;

use qbit;

require QBit::Application::Model::RBAC::DB;

my $USER_ID = 1016;    #mocked-context-adblock-partner'
my $fixture = {
    'foo' => {
        user_id     => $USER_ID,
        right_names => ['right_foo'],
        expect      => {right_foo => TRUE,}
    },
    'foo, bar' => {
        user_id     => $USER_ID,
        right_names => ['right_foo', 'rigth_bar'],
        expect      => {
            right_foo => TRUE,
            rigth_bar => TRUE,
        }
    },
    'foobar' => {
        user_id     => $USER_ID,
        right_names => ['right_foobar'],
        expect      => {right_foobar => FALSE}
    },
};

run_tests(
    sub {
        my ($app) = @_;

        $RoleRights::cache = undef;

        # Проверяем что у $USER_ID есть роли 36,9
        my $roles = $app->rbac->get_roles_by_user_id($USER_ID);
        cmp_deeply([sort keys %$roles], [36, 9], 'Roles');

        # Мокаем права для ролей 36,9
        no warnings 'redefine';
        no strict 'refs';
        *{'RoleRights::_read_role_right'} = sub {
            return {
                'right_foo' => {map {$_ => 1} 9, 36},
                'rigth_bar' => {map {$_ => 1} 9},
                'roght_baz' => {map {$_ => 1} 9}
            };
        };

        foreach my $test_name (sort keys %$fixture) {
            my ($user_id, $right_names, $expect) = @{$fixture->{$test_name}}{qw( user_id  right_names  expect )};

            my $got = QBit::Application::Model::RBAC::DB::get_rights_by_user_id($app->rbac, $user_id, $right_names);

            cmp_deeply($got, $expect, $test_name);
        }
    },
);
