#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::Differences qw(eq_or_diff);

use qbit;
use Test::Partner2::Simple;
require QBit::Application::Model::YandexLangDetect;

my $FIXTURES = {
    'one' => {
        cookimy => 'YyMCAwUnAgABLgEBAA==',
        expect  => 1                         # ru
    },
    'two' => {
        cookimy => 'YycCAAMrAeABz2sA',
        expect  => 3                         # en
    },
};

run_tests(
    sub {
        my ($app) = @_;

        foreach my $testname (sort keys %$FIXTURES) {
            my ($cookiemy, $expect) = @{$FIXTURES->{$testname}}{qw( cookimy expect )};

            my $got = QBit::Application::Model::YandexLangDetect::get_lang_from_cookie_my($cookiemy);
            eq_or_diff($got, $expect, "$testname");
        }
    },
    dont_create_database => 1,
);
