use strict;
use warnings FATAL => 'all';

use qbit;
use Test::Partner2::Simple;
use Test::More;

sub check_1 {
    my $data = [{aa => 1, bb => 2}, {aa => 11, bb => 22}, {aa => 111, bb => 222},];

    my $replace = {
        2  => 2,
        22 => {22 => 22},
    };

    rows_expand($data, bb => $replace => 'BB');

    is_deeply(
        $data,
        [
            {
                'bb' => 2,
                'BB' => 2,
                'aa' => 1
            },
            {
                'bb' => 22,
                'BB' => {'22' => 22},
                'aa' => 11
            },
            {
                'bb' => 222,
                'BB' => undef,
                'aa' => 111
            }
        ],
        'Expand with hash'
    );
}

sub check_2 {
    my $data = [{aa => 1, bb => 2}, {aa => 11, bb => 22}, {aa => 111, bb => 222},];

    my $data2 = [{id => 2, key => 'val'}, {id => 22, key2 => 'val2'},];

    rows_expand($data, bb => ['id' => $data2] => 'BB');
    # ldump($data);

    is_deeply(
        $data,
        [
            {
                'bb' => 2,
                'BB' => {
                    'id'  => 2,
                    'key' => 'val'
                },
                'aa' => 1
            },
            {
                'bb' => 22,
                'BB' => {
                    'key2' => 'val2',
                    'id'   => 22
                },
                'aa' => 11
            },
            {
                'bb' => 222,
                'BB' => undef,
                'aa' => 111
            }
        ],
        'Expand with set'
    );
}

sub check_3 {
    my ($app) = @_;
    my $data =
      [{aa => 1, bb => 2, user_id => 155209804}, {aa => 11, bb => 22, user_id => 9999}, {aa => 111, bb => 222},];

    rows_expand($data, user_id => $app->users => 'user');

    is_deeply(
        $data,
        [
            {
                'bb'   => 2,
                'user' => {
                    'accountant_email'          => undef,
                    'adfox_offer'               => undef,
                    'block_light_form_enabled'  => '0',
                    'business_unit'             => '0',
                    'client_id'                 => '2901607',
                    'country_id'                => undef,
                    'domain_login'              => undef,
                    'email'                     => 'bessarabov@yandex-team.ru',
                    'has_approved'              => '0',
                    'has_mobile_mediation'      => '0',
                    'has_rsya'                  => '1',
                    'has_tutby_agreement'       => '0',
                    'has_common_offer'          => '0',
                    'id'                        => '155209804',
                    'is_adfox_partner'          => '0',
                    'is_efir_blogger'           => '0',
                    'is_games'                  => '0',
                    'is_mobile_mediation'       => '0',
                    'is_tutby'                  => '0',
                    'is_video_blogger'          => '0',
                    'last_payout'               => '1000-01-01 00:00:00',
                    'lastname'                  => '',
                    'login'                     => 'yndx-bessarabov',
                    'midname'                   => '',
                    'multistate'                => '0',
                    'name'                      => '',
                    'need_to_email_processing'  => '0',
                    'newsletter'                => '1',
                    'no_stat_monitoring_emails' => '1',
                    'paid_offer'                => undef,
                    'phone'                     => '',
                    create_date                 => '1000-01-01 00:00:00',
                    is_dm_lite                  => '0',
                    uid                         => '155209804',
                    is_deleted                  => '0',
                    deletion_date               => undef,
                },
                'user_id' => 155209804,
                'aa'      => 1
            },
            {
                'bb'      => 22,
                'user'    => undef,
                'user_id' => 9999,
                'aa'      => 11
            },
            {
                'bb' => 222,
                'aa' => 111
            }
        ],
        'Expand with model'
    );
}

sub check_4 {
    my ($app) = @_;

    my $data =
      [{aa => 1, bb => 2, user_id => 155209804}, {aa => 11, bb => 22, user_id => 9999}, {aa => 111, bb => 222},];

    rows_expand($data, user_id => $app->users => {'user' => [qw(id login client_id)]});

    is_deeply(
        $data,
        [
            {
                'bb'   => 2,
                'user' => {
                    'client_id' => '2901607',
                    'login'     => 'yndx-bessarabov',
                    'id'        => '155209804',
                },
                'user_id' => 155209804,
                'aa'      => 1
            },
            {
                'bb'      => 22,
                'user'    => undef,
                'user_id' => 9999,
                'aa'      => 11
            },
            {
                'bb' => 222,
                'aa' => 111
            }
        ],
        'Expand with model (some fields)'
    );
}

run_tests(
    sub {
        my ($app) = @_;

        check_1();
        check_2();
        check_3($app);
        check_4($app);

    },
);
