use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        no warnings 'redefine';
        no strict 'refs';
        *{'Application::Model::SendMail::send'} = sub { };

        is(ref($app), 'Cron', 'Working with Cron instance');

        # Несуществующая саба
        eval {$app->QBit::Cron::do("system", "no_such_sub");};
        is($@->message, 'Method "no_such_sub" with path "system" does not exists');

        # Саба без атрибута INSTANCE
        eval {$app->QBit::Cron::do("system", "check_impossible_multistates");};
        is($@, '');

        eval {$app->QBit::Cron::do("system", "check_impossible_multistates_1");};
        is($@->message, 'system check_impossible_multistates does not support instance');

        # Еще одна саба без атрибута INSTANCE
        eval {$app->QBit::Cron::do("monitoring", "notify_500");};
        is($@, '');

        eval {$app->QBit::Cron::do("monitoring", "notify_500_1");};
        is($@->message, 'monitoring notify_500 does not support instance');

        # Саба с атрибутом INSTANCE
        eval {$app->QBit::Cron::do("update_bk_async", "async_update_light_pages_in_bk_1");};
        is($@, '');

        eval {$app->QBit::Cron::do("update_bk_async", "async_update_light_pages_in_bk");};
        is($@->message, 'update_bk_async async_update_light_pages_in_bk instance must be defined');

        eval {$app->QBit::Cron::do("update_bk_async", "async_update_light_pages_in_bk_0");};
        is($@->message, 'update_bk_async async_update_light_pages_in_bk instance must be > 0');

        eval {$app->QBit::Cron::do("update_bk_async", "async_update_light_pages_in_bk_100");};
        is($@->message, 'update_bk_async async_update_light_pages_in_bk instance is too big');

    },
    application_package => 'Cron',
);
