#!/usr/bin/perl
use qbit;
use strict;
use warnings;
use Test::More;
my %tests = (
    '54'     => '54 seconds',
    '123'    => '2 minutes 3 seconds',
    '6321'   => '1 hour 45 minutes 21 seconds',
    '92534'  => '1 day 1 hour 42 minutes 14 seconds',
    '0'      => '0 seconds',
    '1'      => '1 second',
    '60'     => '1 minute',
    '62'     => '1 minute 2 seconds',
    '7200'   => '2 hours',
    '172800' => '2 days',
    '86402'  => '1 day 2 seconds'
);
foreach my $in (keys %tests) {
    my $start_time    = $in;
    my $expected_time = $tests{$in};
    is(change_time_format($start_time), $expected_time, 'ok, true time');

}
done_testing();
