#!/usr/bin/perl

use qbit;

use Test::More tests => 1;
use Test::Differences qw(eq_or_diff);

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Mock qw(mock_curdate);

my @periods = ('1w');
push @periods, "${_}d" foreach (1 .. 30);
push @periods, "${_}h" foreach (1 .. 24);
push @periods, "${_}m" foreach (1 .. 60);

my @dates  = ('2020-11-01 00:00:00', '2020-11-27 19:34:51', '2020-11-30 23:59:59',);
my $format = '%-8s%-24s%-24s%s';
my @result = (sprintf($format, '', @dates));
foreach my $period (@periods) {
    my @r = ($period);
    foreach my $dt (@dates) {
        mock_curdate($dt);
        push @r, get_start_of_period($period, oformat => 'db_time',);
    }
    push @result, sprintf($format, @r);
}

my $result = join "\n", @result, '';
my $expected = get_test_data_and_update_if_needed('result.csv', $result, raw => TRUE);
eq_or_diff($result, $expected, "check");
