#!/usr/bin/perl

use qbit;

use Test::More;

use Test::Partner2::Mock qw(mock_curdate);

mock_curdate('2018-03-14 14:54:59');

my $fixture = {
    'undef'        => {'ttl' => undef},
    'empty string' => {'ttl' => ''},
    'only number'  => {'ttl' => '5'},
    'only period'  => {'ttl' => 'day'},
    'not exists'   => {'ttl' => '4notexists'},
    '1year'        => {
        'expected' => '2017-03-14 00:00:00',
        'ttl'      => '1year'
    },
    '2month' => {
        'expected' => '2018-01-14 00:00:00',
        'ttl'      => '2month'
    },
    '3week' => {
        'expected' => '2018-02-21 14:54:59',
        'ttl'      => '3week'
    },
    '4day' => {
        'expected' => '2018-03-10 14:54:59',
        'ttl'      => '4day'
    },
    '5hour' => {
        'expected' => '2018-03-14 09:54:59',
        'ttl'      => '5hour'
    },
    '6minute' => {
        'expected' => '2018-03-14 14:48:59',
        'ttl'      => '6minute'
    },
    '7second' => {
        'expected' => '2018-03-14 14:54:52',
        'ttl'      => '7second'
    },
    'with space' => {
        'expected' => '2018-03-14 14:54:52',
        'ttl'      => '7  second'
    },
};

plan tests => scalar(keys(%$fixture));

foreach my $name (sort keys(%$fixture)) {
    try {
        my $timestamp = get_ttl_timestamp($fixture->{$name}{'ttl'});

        $fixture->{$name}{expected} = trdate('sec', 'db_time', $timestamp);

        is(trdate('sec', 'db_time', $timestamp), $fixture->{$name}{'expected'}, $name);
    }
    catch {
        ok(!$fixture->{$name}{'expected'}, 'Exception throws');
    };
}
