use qbit;

use Test::More;

my %tests = (
    '2018-03-14 14:54:59' => '2018-03-14 14:50:00',
    '2018-03-14 14:55:00' => '2018-03-14 14:55:00',
    '2018-03-14 14:56:10' => '2018-03-14 14:55:00',
);

foreach my $in (keys %tests) {

    my $timestamp          = trdate(db_time => sec => $in);
    my $expected_timestamp = trdate(db_time => sec => $tests{$in});

    is(
        round_timestamp($timestamp),
        $expected_timestamp,
        sprintf('round_timestamp(%s) == %s     (%s => %s)', $timestamp, $expected_timestamp, $in, $tests{$in}),
      );
}

done_testing();
