use qbit;

use Test::More;

is(trdate(db => norm => 0), undef, 'Check bad date');

is_deeply(trdate(norm => norm => [2013, 12, 31, 23, 59, 59]), [2013, 12, 31, 23, 59, 59], 'Check trdate norm => norm');

is_deeply(trdate(norm => db => [2013, 12, 31, 23, 59, 59]), '2013-12-31', 'Check trdate norm => db');
is_deeply(trdate(db => norm => '2013-12-31'), [2013, 12, 31, 0, 0, 0], 'Check trdate db => norm ');

is_deeply(trdate(norm => db_time => [2013, 12, 31, 23, 59, 59]), '2013-12-31 23:59:59', 'Check trdate norm => db');
is_deeply(trdate(db_time => norm => '2013-12-31 23:59:59'), [2013, 12, 31, 23, 59, 59], 'Check trdate db => norm ');

is(trdate(norm => sec => trdate(sec => norm => 1375808504)), 1375808504, 'Check trdate sec => norm => sec');

is(trdate(norm => days_in_month => [2012, 02, 15]), 29, 'Check trdate norm => days_in_month');

is_deeply(trdate(log => norm => '[05/Feb/2019:16:29:57 +0300]'), [2019, 2, 5, 16, 29, 57], 'Check trdate log => norm ');

my %tests = (
    norm              => {map {$_     => [2010, $_, 19]} 1 .. 12,},
    date_only_numbers => {map {$_ + 0 => "2012${_}09"} '01' .. '12',},
    sec               => {map {$_     => -1_000_000 + $_ * 60 * 60 * 24 * 30} 1 .. 12,},
    db                => {map {$_ + 0 => "2017-$_-02"} '01' .. '12',},
    db_time           => {map {$_ + 0 => "2017-$_-02 12:35:09"} '01' .. '12',}
);

for my $format (keys %tests) {
    subtest "$format => month_txt" => sub {
        for my $month (keys %MONTHS_TXT) {
            is(
                trdate($format => month_txt => $tests{$format}{$month}),
                $MONTHS_TXT{$month}->(),
                "Check trdate $format => month_txt for " . $MONTHS_TXT{$month}->()
              );
        }
    };
}

done_testing();
