use qbit;

use Test::More;

is(format_number(12345678.901200, thousands_sep => ',', decimal_point => '.'),
    '12,345,678.9012', 'Checked basic format_number');

is(format_number(12345678.00901200, thousands_sep => ',', decimal_point => '.'),
    '12,345,678.009012', 'Checked basic format_number with started zero');

is(format_number(12345678, thousands_sep => ',', decimal_point => '.'),
    '12,345,678', 'Checked basic format_number without frac');

is(format_number(12345678.901200, thousands_sep => ',', decimal_point => '.', precision => 2),
    '12,345,678.90', 'Checked format_number with precision');

is(format_number(12345678, thousands_sep => ',', decimal_point => '.', precision => 2),
    '12,345,678.00', 'Checked basic format_number with precision without frac');

is(format_number(12345678.901200, thousands_sep => ',', decimal_point => '.', precision => 0),
    '12,345,679', 'Checked format_number with zero precision');

is(format_number(123, thousands_sep => ',', decimal_point => '.'), '123', 'Checked format_number with 3 digits number');

is(format_number(123456, thousands_sep => ',', decimal_point => '.'),
    '123,456', 'Checked format_number with 6 digits number');

is(format_number(0.000123456, thousands_sep => ',', decimal_point => '.', precision => 5),
    '0.00012', 'Checked format_number with started zero number');

is(format_number(9.87165876490036e-05, thousands_sep => ',', decimal_point => '.', precision => 5),
    '0.00001', 'Checked format_number with very small number');

is(format_number('3.12259223215332e-05', thousands_sep => ',', decimal_point => '.', precision => 8),
    '0.00003123', 'Checked format_number with very small number as string');

is(
    format_number('-2533432.12259', thousands_sep => ' ', decimal_point => ',', precision => 2),
    '-2 533 432,12',
    'Checked format_number with negative number as string'
  );

is(
    format_number(-2533432.12259, thousands_sep => ' ', decimal_point => ',', precision => 2),
    '-2 533 432,12',
    'Checked format_number with negative number'
  );

is(format_number('-25.12259e+12', thousands_sep => ',', decimal_point => '.', precision => 4),
    '-25,122,590,000,000.0000', 'Checked format_number with negative small number as string');

done_testing();
