use qbit;

use Test::More;

my $store_ids = {
    'GooglePlay' => 1,
    'AppStore'   => 2,
};

my $fixture = {
    AppStore => {
        OK => [
            'foo',
            'foo-',
            'foo2',
            'foo-bar',
            'foo.bar',
            'foo.-bar',
            'foo.2bar',
            '2foo.bar',
            'foo.bar-baz.bar',
            'foo.bar.foo-bar',
            'foo.bar-baz.2foobar.2bazbar',

            'EK6FF87BD6',
            'AudioViz',
            '433AppStore.-33',
            'Chess-FreeBoardGame',
            'com.200labs.Lenta',
            'picross2',
            'com.H21D.Draw-Dresses-For-Girls.2',

            'com.123456789',
            'com.ID123456789',
            'com.id123456789',
        ],
        FAIL => [
            'foo_',       '-foo.bar', '_foo.bar', 'foo._bar',  'foo.foo_bar', 'public',
            'public.foo', 'dyn',      'dyn.bar',  '123456789', 'id123456789', 'ID123456789',
        ],
    },
    GooglePlay => {
        OK => [
            'foo.bar',
            'foo_bar.baz',
            'foo.foo_bar.baz',

            'com.ktkrsoft.MinesweeperLv99_',
            'com.wVsenovostivodnommesteonlaynAgregatornovosteyNovostiUkrainyiRossiiinovostimira',
        ],
        FAIL => [
            'foo',      'foo_',    'foo2',     'foo-',        'foo_bar', '_foo.bar',
            'foo._bar', 'foo-bar', 'foo.2bar', 'foo-bar.baz', 'com.example'
        ]
    },
};

foreach my $store (sort keys %$fixture) {
    my $store_id = $store_ids->{$store};
    note "$store";
    foreach my $is_ok (sort keys %{$fixture->{$store}}) {
        foreach my $bundle_id (@{$fixture->{$store}->{$is_ok}}) {
            my $expect = $is_ok eq 'FAIL' ? undef : $bundle_id;
            is(get_bundle_id($bundle_id, $store_id), $expect, "'$bundle_id' is $is_ok ($store)");
        }
    }
}

done_testing();
