#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More tests => 14;

use qbit;
use QBit::Validator;

ok(
    !QBit::Validator->new(
        data     => '0',
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean and get 0 as string (no error)'
  );

ok(
    !QBit::Validator->new(
        data     => '1',
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean and get 1 as string (no error)'
  );

ok(
    QBit::Validator->new(
        data     => '2',
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean and get 2 as string (error)'
  );

ok(
    !QBit::Validator->new(
        data     => 0,
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean and get 0 as number (no error)'
  );

ok(
    !QBit::Validator->new(
        data     => 1,
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean and get 1 as number (no error)'
  );

ok(
    QBit::Validator->new(
        data     => 2,
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean and get 2 as number (error)'
  );

ok(
    QBit::Validator->new(
        data     => from_json('true'),
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean (json true) (error)'
  );

ok(
    QBit::Validator->new(
        data     => from_json('false'),
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean (json false) (error)'
  );

ok(
    !QBit::Validator->new(
        data     => from_json('1'),
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean (json 1) (no error)'
  );

ok(
    !QBit::Validator->new(
        data     => from_json('0'),
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean (json 0) (no error)'
  );

ok(
    QBit::Validator->new(
        data     => from_json('2'),
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean (json 2) (error)'
  );

ok(
    !QBit::Validator->new(
        data     => from_json('"1"'),
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean (json "1") (no error)'
  );

ok(
    !QBit::Validator->new(
        data     => from_json('"0"'),
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean (json "0") (no error)'
  );

ok(
    QBit::Validator->new(
        data     => from_json('"2"'),
        template => {type => 'boolean',},
      )->has_errors,
    'type = boolean (json "2") (error)'
  );
