#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More tests => 8;

use qbit;
use QBit::Validator;
use PiConstants qw($MAX_CPM);

ok(
    QBit::Validator->new(
        data     => 'string',
        template => {type => 'cpm',},
      )->has_errors,
    'type = string (error)'
  );

ok(
    !QBit::Validator->new(
        data     => '13',
        template => {type => 'cpm'},
      )->has_errors,
    'type = get string "13" (no error)'
  );

ok(
    QBit::Validator->new(
        data     => -27,
        template => {type => 'cpm'},
      )->has_errors,
    'type = get negative number (error)'
  );

ok(
    !QBit::Validator->new(
        data     => 27.56,
        template => {type => 'cpm'},
      )->has_errors,
    'type = get float number (no error)'
  );

ok(
    !QBit::Validator->new(
        data     => 18,
        template => {type => 'cpm'},
      )->has_errors,
    'type = cpm (no error)'
  );

ok(
    QBit::Validator->new(
        data     => -1,
        template => {type => 'cpm'},
      )->has_errors,
    'type = -1 (error)'
  );

ok(
    QBit::Validator->new(
        data     => $MAX_CPM + 1,
        template => {type => 'cpm'},
      )->has_errors,
    'type = too big (error)'
  );

ok(
    QBit::Validator->new(
        data     => 0,
        template => {type => 'cpm'},
      )->has_errors,
    'type = 0 not allow (error)'
  );
