#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More tests => 5;

use qbit;
use QBit::Validator;

########
# Date #
########

ok(QBit::Validator->new(data => [], template => {type => 'date'},)->has_errors, 'Default type: SCALAR');

#
# optional
#

ok(!QBit::Validator->new(data => undef, template => {type => 'date', optional => TRUE},)->has_errors, 'OK');

#
# format
#

my $error = FALSE;
try {
    QBit::Validator->new(data => '2017-06-23', template => {format => ['db']},);
}
catch {
    $error = TRUE;
};
ok($error, 'Check "format" for date (bad format)');

ok(!QBit::Validator->new(data => '2017-06-23', template => {type => 'date', format => 'db'},)->has_errors,
    'Format: db');

ok(QBit::Validator->new(data => '2017-06', template => {type => 'date', format => 'db'},)->has_errors,
    'Format: db; bad data');
