#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs;

use Test::More tests => 32;
use Test::Deep qw(cmp_deeply);
use Test::Differences qw(eq_or_diff);

use qbit;

use Application;

use QBit::Validator;

use Test::Partner2::Mock qw(mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use PiConstants qw($DEFAULT_DESIGN_TYPE);

###################
# Design template #
###################

my $app = Application->new()->pre_run();
my $rtb = $app->context_on_site_rtb;
$app->api_format_system;

my $ROLE;
my $PARAMS  = [];
my $ANSWERS = [];
my $FORMAT_TMP =
  from_json(readfile(lib::abs::path('../../../../../t_lib/Test/Partner2/Mock/api_format_system_formats_240x400.json')));
my $FORMAT = $FORMAT_TMP;

mock_subs(
    {
        'Application::Model::Product::AN::ContextOnSite::RTB::check_feature_on_page' => sub {TRUE},
        'Application::Model::Product::AN::ContextOnSite::RTB::check_short_rights'    => sub {$ROLE ne 'partner'},
        'Application::Model::API::Yandex::FormatSystem::validate' => sub {
            my ($self, %opts) = @_;

            cmp_deeply(\%opts, shift(@$PARAMS), 'validate opts');

            return shift(@$ANSWERS);
        },
        'Application::Model::API::Yandex::FormatSystem::formats' => sub {
            my ($self, %opts) = @_;

            return $FORMAT;
        },
        'Application::Model::Block::get_features_and_options_on_page' => sub {
            return {};
          }
    }
);

my $design_settings = {
    'borderType'      => 'none',
    'favicon'         => JSON::XS::true,
    'headerBgColor'   => 'FEEAC7',
    'horizontalAlign' => JSON::XS::false,
    'hoverColor'      => '0066FF',
    'imagesFirst'     => JSON::XS::false,
    'limit'           => 1,
    'linksUnderline'  => JSON::XS::false,
    'name'            => '728x90',
    'noSitelinks'     => JSON::XS::true,
    'siteBgColor'     => 'FFFFFF',
    'textColor'       => '000000',
    'titleColor'      => '0000CC',
    'urlColor'        => '006600'
};

my $design_template = {
    'block_id'                => '1',
    'caption'                 => "Исходный дизайн",
    'design_settings'         => $design_settings,
    'filter_tags'             => undef,
    'type'                    => $DEFAULT_DESIGN_TYPE,
    'form_factor'             => 'horizontal',
    'id'                      => '1000000',
    'is_custom_format_direct' => '0',
    'page_id'                 => '1037'
};

my $block_with_design_templates = {
    'page_id'          => 1037,
    'id'               => 1,
    'site_version'     => 'desktop',
    'design_templates' => [$design_template],
};

my $template = {
    type   => 'hash',
    fields => {design_templates => {type => 'array', all => {type => 'design_template'},}},
    extra  => TRUE,
};

my $tests = get_test_data_and_update_if_needed('data.json');

foreach my $test (@$tests) {
    $ROLE    = $test->{'role'};
    $PARAMS  = clone($test->{'params'});
    $ANSWERS = clone($test->{'answers'});
    $FORMAT  = clone($FORMAT_TMP);

    if (exists($test->{'not_accessible_fields'})) {
        my %not_accessible_fields = map {$_ => TRUE} @{$test->{'not_accessible_fields'}};

        $FORMAT->{'settings'} = [grep {!$not_accessible_fields{$_->{'name'}}} @{$FORMAT->{'settings'}}];
    }

    my $qv = QBit::Validator->new(
        data     => $test->{'data'},
        stash    => {current => $block_with_design_templates},
        template => $template,
        app      => $rtb,
    );

    my $errors = $qv->get_all_errors();

    eq_or_diff($errors, $test->{'errors'}, $test->{'name'});

    $test->{'errors'} = $errors;
}

get_test_data_and_update_if_needed('data.json', $tests);
