#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More tests => 13;
use Test::Deep;

use qbit;
use QBit::Validator;

my $TESTS = [
    {
        name   => 'gps',
        data   => '-18.34512324,90.12879345',
        result => TRUE,
    },
    {
        name   => 'gps empty',
        data   => '',
        result => FALSE,
    },
    {
        name   => 'gps undef',
        data   => undef,
        result => FALSE,
    },
    {
        name   => 'gps only separator',
        data   => ',',
        result => FALSE,
    },
    {
        name   => 'gps only latitude v1',
        data   => '-89.000,',
        result => FALSE,
    },
    {
        name   => 'gps only latitude v2',
        data   => '-89.000,',
        result => FALSE,
    },
    {
        name   => 'gps only latitude v2',
        data   => '-89.000,',
        result => FALSE,
    },
    {
        name   => 'gps two separators',
        data   => '0.0,,-89.000',
        result => FALSE,
    },
    {
        name   => 'gps whitespaces',
        data   => ' +0.0 , -89.000 ',
        result => TRUE,
    },
    {
        name   => 'gps wrong latitude',
        data   => '+180.000, -89.000',
        result => FALSE,
    },
    {
        name   => 'gps wrong longitude',
        data   => '50.000, -1000.11',
        result => FALSE,
    },
    {
        name   => 'gps wrong numbers v1',
        data   => '50.0a00, -1000.11',
        result => FALSE,
    },
    {
        name   => 'gps wrong numbers v2',
        data   => '50.000, -10a00.11',
        result => FALSE,
    },
];

foreach my $test (@$TESTS) {
    my $result = !QBit::Validator->new(
        data     => $test->{'data'},
        template => {type => 'gps',},
    )->has_errors;

    ok($result eq $test->{'result'}, $test->{'name'});
}
