#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More tests => 5;

use qbit;
use QBit::Validator;

ok(
    QBit::Validator->new(
        data     => 'string',
        template => {type => 'int_un',},
      )->has_errors,
    'type = int_un and get string (error)'
  );

ok(
    !QBit::Validator->new(
        data     => '13',
        template => {type => 'int_un',},
      )->has_errors,
    'type = int_un and get string "13" (no error)'
  );

ok(
    QBit::Validator->new(
        data     => -27,
        template => {type => 'int_un',},
      )->has_errors,
    'type = int_un and get negative number (error)'
  );

ok(
    QBit::Validator->new(
        data     => 27.56,
        template => {type => 'int_un',},
      )->has_errors,
    'type = int_un and get float number (error)'
  );

ok(
    !QBit::Validator->new(
        data     => 18,
        template => {type => 'int_un',},
      )->has_errors,
    'type = int_un (no error)'
  );
