#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More tests => 6;

use qbit;
use QBit::Validator;

########
# JSON #
########

ok(!QBit::Validator->new(data => '{}', template => {type => 'json'},)->has_errors, 'Use type "json"');

ok(QBit::Validator->new(data => {}, template => {type => 'json'},)->has_errors, 'Use type "json" and data HASH');

my $error;
try {
    QBit::Validator->new(data => '{}', template => {type => 'json', schema => undef},);
}
catch {
    $error = shift;
};
ok($error, 'Throw exception');
is($error->message, gettext('Key "%s" must be defined', 'schema'), 'Message correct');

my $schema = {
    type       => 'object',
    properties => {key => {type => 'number'},},
};

ok(
    !QBit::Validator->new(data => to_json({key => 123}), template => {type => 'json', schema => $schema},)->has_errors,
    'Match with schema'
  );

ok(
    QBit::Validator->new(data => to_json({key => 'string'}), template => {type => 'json', schema => $schema},)
      ->has_errors,
    'Not match with schema'
  );
