#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More tests => 5;

use qbit;
use QBit::Validator;

ok(
    !QBit::Validator->new(
        data     => JSON::XS::false,
        template => {type => 'json_boolean'},
      )->has_errors,
    'type = boolean and value is false (no error)'
  );

ok(
    !QBit::Validator->new(
        data     => JSON::XS::true,
        template => {type => 'json_boolean'},
      )->has_errors,
    'type = boolean and value is true (no error)'
  );

ok(
    QBit::Validator->new(
        data     => 'true',
        template => {type => 'json_boolean'},
      )->has_errors,
    'type = string and value is "true" (error)'
  );

ok(
    QBit::Validator->new(
        data     => 1,
        template => {type => 'json_boolean'},
      )->has_errors,
    'type = number and value is "1" (error)'
  );

ok(
    QBit::Validator->new(
        data     => \1,
        template => {type => 'json_boolean'},
      )->has_errors,
    'type = ref and value is "\1" (error)'
  );
