#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More tests => 15;

use qbit;

use Test::Partner2::Simple;
use QBit::Validator;

run_tests(
    sub {
        my ($app) = @_;

        ok(QBit::Validator->new(data => undef, template => {type => "picategories"})->has_errors,
            'Use type "picategories" and data = undef');

        ok(!QBit::Validator->new(data => undef, template => {type => "picategories", optional => TRUE})->has_errors,
            'Use type "picategories" and data = undef');

        my $validator = QBit::Validator->new(
            data     => [],
            template => {type => "picategories"},
            app      => $app->context_on_site_rtb,
        );
        ok(!$validator->has_errors, 'empty array');

        $validator = QBit::Validator->new(
            data     => [1],
            template => {type => "picategories"},
            app      => $app->context_on_site_rtb,
        );
        ok($validator->has_errors, 'bad format');

        $validator = QBit::Validator->new(
            data     => [{}],
            template => {type => "picategories"},
            app      => $app->context_on_site_rtb,
        );
        ok($validator->has_errors, 'bad format 2');

        $validator = QBit::Validator->new(
            data     => [{a   => 1}],
            template => {type => "picategories"},
            app      => $app->context_on_site_rtb,
        );
        ok($validator->has_errors, 'bad format 3');

        $validator = QBit::Validator->new(
            data     => [{id  => "1", cpm => 1}, {id => "1", cpm => 2}],
            template => {type => "picategories"},
            app      => $app->context_on_site_rtb,
        );
        ok($validator->has_errors, 'Identical records found');

        $validator = QBit::Validator->new(
            data     => [{id  => "1000", cpm => 1}],
            template => {type => "picategories"},
            app      => $app->context_on_site_rtb,
        );
        ok($validator->has_errors, 'PICategories not found');

        $validator = QBit::Validator->new(
            data     => [{id  => "1", cpm => 0}],
            template => {type => "picategories"},
            app      => $app->context_on_site_rtb,
        );
        ok($validator->has_errors, 'cpm == 0 is not valid');

        $validator = QBit::Validator->new(
            data     => [{id  => "1", cpm => 10000}],
            template => {type => "picategories"},
            app      => $app->context_on_site_rtb,
        );
        ok($validator->has_errors, 'cpm == 10000 is not valid');

        $validator = QBit::Validator->new(
            data     => [{id  => "1", cpm => -1}],
            template => {type => "picategories"},
            app      => $app->context_on_site_rtb,
        );
        ok($validator->has_errors, 'cpm == -1 is not valid');

        $validator = QBit::Validator->new(
            data     => [{id  => "1", cpm => 1}],
            template => {type => "picategories"},
            app      => $app->context_on_site_rtb,
        );
        ok(!$validator->has_errors, 'cpm == 1 is valid');

        $validator = QBit::Validator->new(
            data     => [{id  => "1", cpm => 9999}],
            template => {type => "picategories"},
            app      => $app->context_on_site_rtb,
        );
        ok(!$validator->has_errors, 'cpm == 9999 is valid');
    },
);
