use strict;
use warnings FATAL => 'all';

use qbit;
use QBit::Validator;

use Test::More tests => 4;
use Test::Deep qw(cmp_deeply);

use Application;

my $app = Application->new();

$app->pre_run();

my $public_id = 'not_exists_public_id';

my $qv = QBit::Validator->new(
    data     => $public_id,
    template => {
        type  => 'publicid',
        check => sub {return ''}
    },
    app => $app->context_on_site_rtb
);

ok(!$qv->has_errors, 'No error');

cmp_deeply([$qv->_get_all_types('publicid')], ['publicid', 'scalar'], 'Check types');

$qv = QBit::Validator->new(
    data     => $public_id,
    template => {
        type  => 'publicid',
        check => sub {
            my ($qv) = @_;

            my $err = $qv->super_check('publicid', @_);

            return $err if $err;

            return '';
          }
    },
    app => $app->context_on_site_rtb
);

ok($qv->has_errors, 'Error');

cmp_deeply(
    [$qv->get_fields_with_error()],
    [
        {
            'path' => [],
            'msgs' => [gettext('Invalid public_id "%s"', $public_id)]
        }
    ],
    'Correct error with super_check'
);

$app->post_run();
