#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use FindBin qw($Bin);
use lib "$Bin/../lib";

use Test::More tests => 7;

use qbit;
use QBit::Class;
use QBit::Validator;

#######
# REF #
#######

ok(!QBit::Validator->new(data => \7, template => {type => 'ref'},)->has_errors, 'Check "ref"');

ok(QBit::Validator->new(data => 7, template => {type => 'ref'},)->has_errors, 'Error "ref"');

ok(!QBit::Validator->new(data => \7, template => {type => 'ref', ref_value => 'SCALAR'},)->has_errors,
    'ref_value = SCALAR');

try {
    QBit::Validator->new(data => \7, template => {type => 'ref', ref_value => []},);
}
finally {
    my ($e) = @_;

    ok($e, 'Exception');
    is($e->message, gettext('Option "%s" must be type "Scalar"', 'ref_value'), 'message correctly');
};

ok(
    !QBit::Validator->new(data => QBit::Class->new(), template => {type => 'ref', ref_value => 'QBit::Class'},)
      ->has_errors,
    'ref_value = QBit::Class'
  );

ok(
    QBit::Validator->new(data => QBit::Class->new(), template => {type => 'ref', ref_value => 'QBit::Application'},)
      ->has_errors,
    'ref_value = QBit::Application'
  );
