#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More tests => 13;
use Test::Deep;

use qbit;
use QBit::Validator;

my $TESTS = [
    {
        name   => 'resolution',
        data   => '1440x720',
        result => TRUE,
    },
    {
        name   => 'resolution not used with this facility_type',
        data   => '1024x768',
        result => FALSE,
    },
    {
        name   => 'resolution whitespaces',
        data   => ' 1024 x 768 ',
        result => FALSE,
    },
    {
        name   => 'resolution empty',
        data   => '',
        result => FALSE,
    },
    {
        name   => 'resolution undef',
        data   => undef,
        result => FALSE,
    },
    {
        name   => 'resolution only height',
        data   => 'x1',
        result => FALSE,
    },
    {
        name   => 'resolution only width',
        data   => '1x',
        result => FALSE,
    },
    {
        name   => 'resolution wo delim',
        data   => '1024768',
        result => FALSE,
    },
    {
        name   => 'resolution non-standart delim',
        data   => '1024:768',
        result => FALSE,
    },
    {
        name   => 'resolution two delims',
        data   => '1024xx768',
        result => FALSE,
    },
    {
        name   => 'resolution non-digits',
        data   => '10A4x7F8',
        result => FALSE,
    },
];

run_tests(
    sub {
        my ($app) = @_;
        foreach my $test (@$TESTS) {
            my $result = !QBit::Validator->new(
                data     => {page_id => 400, resolution => $test->{'data'}},
                app      => $app->outdoor_block,
                template => {
                    type   => "hash",
                    fields => {
                        page_id    => {},
                        resolution => {type => 'resolution'},
                    }
                }
            )->has_errors;

            ok($result eq $test->{'result'}, $test->{'name'});
        }
    }
);
