use strict;
use warnings FATAL => 'all';

use QBit::Validator;

use Test::More;
use Test::Deep;

sub main_in_test {

    pass('Loaded ok');

    my $qv = QBit::Validator->new(
        data     => {limit => 4,},
        template => {
            type   => 'hash',
            fields => {
                limit => {
                    type  => 'int_un',
                    check => sub {
                        my ($qv, $limit) = @_;

                        throw Exception::Validator::Fields 'Limit must be not more that 2' if $limit > 2;
                    },
                },
            },
        }
    );

    ok($qv->has_errors);

    my @e = $qv->get_fields_with_error();

    cmp_deeply(
        \@e,
        [
            {
                'path' => ['limit'],
                'msgs' => ['Limit must be not more that 2']
            },
        ]
    );

    done_testing();

}
main_in_test();
