use strict;
use warnings FATAL => 'all';

use qbit;
use QBit::Validator;

use Test::More;
use Test::Deep qw(cmp_deeply);

sub main_in_test {

    pass('Loaded ok');

    my $qv = QBit::Validator->new(
        data => {
            alt_width  => 0,
            alt_height => 0,
        },
        template => {
            type   => 'hash',
            fields => {
                alt_width => {
                    type => 'int_un',
                    min  => 1,
                },
                alt_height => {
                    type => 'int_un',
                    min  => 1,
                },
            },
        }
    );

    ok($qv->has_errors);

    my @e = $qv->get_fields_with_error();

    cmp_deeply(
        \@e,
        [
            {
                'path' => ['alt_height'],
                'msgs' => ['Must be an unsigned integer']
            },
            {
                'path' => ['alt_width'],
                'msgs' => ['Must be an unsigned integer']
            }
        ]
    );

    done_testing();

}
main_in_test();
