#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Differences qw(eq_or_diff);

use qbit;

use Test::Partner2::Simple;

run_tests(
    sub {
        my ($app) = @_;

        my $controller = $app->app->{'controller_class'};

        my $c = $controller->new();

        my $TESTS = [
            {
                name   => 'old format - AND',
                filter => ['AND', [['field1', 'IN', [1, 2]], ['field2', '=', 3]]],
                result => ['AND', [['field1', 'IN', [1, 2]], ['field2', '=', 3]]],
            },
            {
                name   => 'old format - HASH',
                filter => {'field1' => [1, 2], 'field2' => 3},
                result => ['AND', [['field1', '=', [1, 2]], ['field2', '=', 3]]],
            },
            {
                name   => 'old format - AND with subfilter',
                filter => ['AND', [['field1', 'MATCH', ['field3', 'NOT IN', [9, 8]]], {'field2' => 3}]],
                result => ['AND', [['field1', 'MATCH', ['field3', 'NOT IN', [9, 8]]], ['AND', [['field2', '=', 3]]]]],
            },
            {
                name   => 'new format - HASH with simple fields',
                filter => {'field1' => ['IN', [1, 2]], 'field2' => ['=', 3]},
                result => ['AND', [['field1', 'IN', [1, 2]], ['field2', '=', 3]]],
            },
            {
                name   => 'new format - HASH with subfilter',
                filter => {'field1.field3' => ['NOT IN', [9, 8]], 'field2' => ['=', 3]},
                result => ['AND', [['field1', 'MATCH', ['field3', 'NOT IN', [9, 8]]], ['field2', '=', 3]]],
            },
        ];

        foreach my $t (@$TESTS) {
            no strict 'refs';
            no warnings 'redefine';

            *{"$controller\::param"} = sub {to_json($t->{'filter'})};

            eq_or_diff($c->get_filter(), $t->{'result'}, $t->{'name'});
        }
    },
    application_package  => 'RestApi',
    dont_create_database => TRUE,
);
