package Test::DB::MySQL;

use qbit;

use DBI;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        table => {
            fields => [
                {name => 'id',         type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'field',      type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'field_str',  type => 'VARCHAR', length   => 32,   not_null => TRUE},
                {name => 'field_i18n', type => 'VARCHAR', length   => 12,   not_null => TRUE, i18n          => TRUE},
            ],
            primary_key => ['id'],
        },
    }
);

sub _connect {
    my ($self) = @_;

    unless (defined($self->{'__DBH__'})) {
        $self->{'__DBH__'}{$$} = DBI->connect('DBI:Mock:', '', '') || throw DBI::errstr();
    }

}

TRUE;
