package Test::MockObject::Extends::Easy;

use base qw(Test::MockObject::Extends);
use strict;
use warnings FATAL => 'all';

use Test::Deep qw();
use Test::Differences qw();

use SQL::Beautify;
use Clone qw(clone);

use qbit;

sub new {
    my $self = shift;

    $self = $self->SUPER::new(@_);

    no strict 'refs';
    no warnings 'redefine';
    *{ref($self) . '::mock_get_return'}     = \&mock_get_return;
    *{ref($self) . '::mock_get_return_sql'} = \&mock_get_return_sql;
    *{ref($self) . '::is_deeply'}           = \&is_deeply;
    *{ref($self) . '::eq_or_diff'}          = \&eq_or_diff;
    *{ref($self) . '::return'}              = \&return;

    return $self;
}

our $beautifier_on = FALSE;

sub mock_get_return_sql {
    local $beautifier_on = TRUE;
    &mock_get_return;
}

sub mock_get_return {
    my $self   = shift;
    my $method = shift;

    my $gotten   = [];
    my $expected = [];
    my $return   = [];

    my $sub_beautify = sub {
        if ($beautifier_on) {
            my $beautifier = SQL::Beautify->new;
            $beautifier->query($_[0]);
            return $beautifier->beautify();
        } else {
            return $_[0];
        }
    };

    while (@_) {
        my ($expected_item, $return_item) = (shift, shift);
        $expected_item->[0] = $sub_beautify->($expected_item->[0]);
        push(@$expected, $expected_item);
        push(@$return,   $return_item);
    }
    $self->{__GOTTEN__}->{$method}   = $gotten;
    $self->{__EXPECTED__}->{$method} = $expected;
    $self->{__RETURN__}->{$method}   = $return;

    my $beautifier_enabled = $beautifier_on;

    $self->SUPER::mock(
        $method => sub {
            my ($self) = @_;
            local $beautifier_on = $beautifier_enabled;
            my $gotten_item = [$sub_beautify->($_[1]), @_[2 .. $#_]];
            push @$gotten, $gotten_item;
            if (!@$return) {
                no strict 'refs';
                warn(
"\nTest::MockObject::Extends::Easy( @{ref($self) . '::ISA'}[0]::$method ):\nNo value to return in answer for \n"
                      . Dumper($gotten_item)
                      . ".\n\n");
                die "\n";
            }

            my $result = shift(@$return);
            return @$result == 1 ? $result->[0] : @$result;
        }
    );
}

sub is_deeply {
    my ($self, $comment) = @_;

    my $success = TRUE;
    foreach my $method (@{array_uniq(keys %{$self->{__GOTTEN__}}, keys %{$self->{__EXPECTED__}})}) {
        $success &&= Test::Deep::cmp_deeply($self->{__GOTTEN__}->{$method}, $self->{__EXPECTED__}->{$method}, $comment);
    }
    $self->eq_or_diff($comment)
      unless $success;
}

sub eq_or_diff {
    my ($self, $comment) = @_;

    foreach my $method (@{array_uniq(keys %{$self->{__GOTTEN__}}, keys %{$self->{__EXPECTED__}})}) {
        my $success =
          Test::Differences::eq_or_diff($self->{__GOTTEN__}->{$method}, $self->{__EXPECTED__}->{$method}, $comment);

        unless ($success) {
            # Make deeply demostrative comparison if there is an error.
            my $gotten   = clone($self->{__GOTTEN__}->{$method});
            my $expected = clone($self->{__EXPECTED__}->{$method});
            my $sub_eq_or_diff_arrays;
            $sub_eq_or_diff_arrays = sub {
                my $gotten   = shift;
                my $expected = shift;
                my $comment  = shift;

                while (@$gotten || @$expected) {
                    my $gotten   = shift @$gotten;
                    my $expected = shift @$expected;
                    if (   (ref($gotten) eq 'ARRAY' || !defined($gotten))
                        && (ref($expected) eq 'ARRAY' || !defined($expected))
                        && (defined($gotten) || defined($expected)))
                    {
                        $gotten   ||= [];
                        $expected ||= [];
                        $sub_eq_or_diff_arrays->($gotten, $expected, $comment);
                    } else {
                        Test::Differences::eq_or_diff($gotten, $expected, $comment);
                    }
                }
            };
            $sub_eq_or_diff_arrays->($gotten, $expected, $comment);
        }
    }
}

sub return {
    my ($self, $method) = @_;

    return @{$self->{__RETURN__}->{$method}};
}

TRUE;
