package Test::Partner::DB::Mock;
use base qw(DBI);

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Partner::DB::Mock::st;
use Test::Partner::DB::Mock::db;
use Test::MockObject::Extends;

sub connect {
    my ($self, $app) = @_;

    $app->partner_db();

    {
        no strict 'refs';
        no warnings 'redefine';

        foreach my $method (
            qw(
            QBit::Application::Model::DB::_do
            QBit::Application::Model::DB::mysql::_connect
            )
          )
        {
            *{$method} = sub {
                die
                  "You didn't mocked the database method '$method'!\nOriginal database writing operation is called!\n";
              }
        }

        *{'DBI::db::get_info'} = sub {
            if ($_[1] == 29) {
                return '`';
            } else {
                return &DBD::SQLite::db::get_info;
            }
        };
    }

    return $self->SUPER::connect("dbi:SQLite:dbname=:memory:", "", "", {RaiseError => TRUE});
}

TRUE;
