#!/usr/bin/perl

use Test::Most tests => 3;
use Test::Deep qw(cmp_deeply);
use Test::Differences qw(eq_or_diff);

use qbit;

use lib::abs;

use Test::Partner2::Mock qw(mock_curdate);

use Utils::Betas;

$Utils::Betas::PATH = lib::abs::path('./betas_storage');

my $time  = '2019-10-16 12:43:34';
my $time2 = '2019-10-16 12:43:43';

mock_curdate($time);

my $betas = Utils::Betas->new();

$betas->add('project', 'stage');

cmp_deeply(
    $betas->{'__STORAGE__'},
    {
        'last_stage' => ['project', 'stage'],
        'projects' => {'project' => {'stage' => {'create_datetime' => $time}}}
    },
    'after add'
);

mock_curdate($time2);

$betas->add('project', 'stage2');

cmp_deeply(
    $betas->{'__STORAGE__'},
    {
        'last_stage' => ['project', 'stage2'],
        'projects'   => {
            'project' => {
                'stage'  => {'create_datetime' => $time},
                'stage2' => {'create_datetime' => $time2}
            }
        }
    },
    'add second stage'
);

eq_or_diff(readfile($Utils::Betas::PATH), to_json($betas->{'__STORAGE__'}, pretty => TRUE), 'Correct content');

END {
    unlink $Utils::Betas::PATH;
}
