use qbit;

use Test::More tests => 12;
use Test::Exception;
use Test::MockObject::Extends;

my $exit_status;

{

    package Utils::ClickHouse::Local;
    use Test::More;
    use subs 'system';

    sub system {
        my ($line) = @_;
        is(
            $line,
"bash -c \"set -o pipefail; cat men.tsv women.tsv 2>fake_temp_file | clickhouse-local -S 'name String,height UInt32,weight UInt32' --query='select * from table' 1>all.tsv 2>>fake_temp_file\"",
            'invocation line'
          );
        return $exit_status;
    }
}

use Utils::ClickHouse::Local;

{
    no warnings 'redefine';

    *Utils::ClickHouse::Local::tempfile = sub {
        my (@args) = @_;
        is_deeply(\@args, [UNLINK => 1], 'tempfile args');
        return (undef, 'fake_temp_file');
    };

    *Utils::ClickHouse::Local::read_file = sub {
        my ($filename) = @_;
        is($filename, 'fake_temp_file', 'stderr read_file');
        return 'fake_stderr';
    };
}

my $structure = [
    'name'   => 'String',
    'height' => 'UInt32',
    'weight' => 'UInt32',
];

my $ch = Test::MockObject::Extends->new('Utils::ClickHouse::Local');
$ch->{input_files} = ['men.tsv', 'women.tsv'];
$ch->{output_file} = 'all.tsv';
$ch->structure($structure);

$exit_status = 0;
lives_ok {
    $ch->query('select * from table');
}
'query';
$exit_status = -1;
throws_ok {
    $ch->query('select * from table');
}
'Exception::ClickHouse', '-1 status exception';
ok($@->message =~ m/^Failed to start clickhouse-local: /, '-1 exception message');
$exit_status = 137;
throws_ok {
    $ch->query('select * from table');
}
'Exception::ClickHouse', 'non-zero status exception';
is(
    $@->message,
    "clickhouse-local exited with non-zero status 137. stderr dump:\nfake_stderr",
    'non-zero status exception message'
  );
