use qbit;

use Test::More tests => 4;
use Test::MockObject::Extends;

use Utils::ClickHouse::Local;

my $ch        = Test::MockObject::Extends->new('Utils::ClickHouse::Local');
my $structure = [
    'name'   => 'String',
    'height' => 'UInt32',
    'weight' => 'UInt32',
];
my $new_structure = [
    'name'   => 'String',
    'height' => 'UInt32',
    'weight' => 'UInt32',
];
$ch->{structure} = $structure;

is_deeply($ch->structure(), $structure, '$ch->structure()');
$ch->structure($new_structure);
is_deeply($ch->{structure}, $new_structure,                            'new $ch->{structure}');
is_deeply($ch->structure(), $new_structure,                            'new $ch->structure()');
is_deeply($ch->{_vars},     'name String,height UInt32,weight UInt32', '_vars');
