use strict;
use warnings FATAL => 'all';

use Test::More tests => 4;
use Utils::Cron;

my @tests = (
    {
        in  => '* * * * *',
        out => 3600,
    },
    {
        in  => '*/5 * * * *',
        out => 3600,
    },
    {
        in  => '0 9 * * 2',    # В 09:00 каждый вторник
        out => 8 * 86_400,
    },
    {
        in  => '0 20 1,15 * *',
        out => 864000,
    },
);

foreach my $t (@tests) {
    is(get_ttl_from_cron_time_date_fields($t->{in}), $t->{out}, "'$t->{in}' => $t->{out}");
}
