use strict;
use warnings FATAL => 'all';

use Utils::DB;
use Test::More;

sub main_in_test {

    is_deeply(
        Utils::DB::_convert_config_to_settings(
            {
                partnerdb2 => {
                    host     => 'dev-partner2.ppc.yandex.ru',
                    port     => 3478,
                    user     => 'pi2_dev',
                    password => 'secret',
                }
            }
        ),
        {
            banks_db => {
                database => 'kladr',
                host     => 'dev-partner2.ppc.yandex.ru',
                password => 'secret',
                port     => 3478,
                user     => 'pi2_dev',
            },
            kladr => {
                database => 'kladr',
                host     => 'dev-partner2.ppc.yandex.ru',
                password => 'secret',
                port     => 3478,
                user     => 'pi2_dev',
            },
            partner_db => {
                database => 'partner',
                host     => 'dev-partner2.ppc.yandex.ru',
                password => 'secret',
                port     => 3478,
                user     => 'pi2_dev',
            },
            partner_logs_db => {
                database => 'partner_logs',
                host     => 'dev-partner2.ppc.yandex.ru',
                password => 'secret',
                port     => 3478,
                user     => 'pi2_dev',
            },
        },
        'Current version of DatabaseConfig.json',
    );

    done_testing();
}
main_in_test();
