#!/usr/bin/perl

use Test::More tests => 6;
use Test::Differences qw(eq_or_diff);

use qbit;

use Utils::DB qw(fields_to_filter);

my $FIXTURES = [
    {
        pk_fields => [qw(page_id id)],
        data      => [{page_id => 1}],
        error     => '[page_id,id] should exist and be defined in every hash of 2nd arg'
    },
    {
        pk_fields => [qw(page_id id)],
        data      => [{id => 1}],
        error     => '[page_id,id] should exist and be defined in every hash of 2nd arg'
    },
    {
        pk_fields => [qw(page_id block_id)],
        data      => [],
        for_db    => TRUE,
        expected  => ['AND', [\undef]]
    },
    {
        pk_fields => [qw(page_id block_id)],
        data      => [],
        for_db    => FALSE,
        expected  => [undef]
    },
    {
        pk_fields => [qw(page_id block_id)],
        data      => [{page_id => 1, block_id => 1}, {page_id => 2, block_id => 1}, {page_id => 2, block_id => 2}],
        for_db    => TRUE,
        expected  => [
            'OR',
            [
                ['AND', [['page_id', '=', \'1'], ['block_id', 'IN', \['1']]]],
                ['AND', [['page_id', '=', \'2'], ['block_id', 'IN', \['1', '2']]]]
            ]
        ]
    },
    {
        pk_fields => [qw(campaign_id id)],
        data      => [{campaign_id => 1, id => 1}, {campaign_id => 2, id => 1}, {campaign_id => 2, id => 2}],
        for_db    => FALSE,
        expected  => [
            'OR',
            [
                ['AND', [['campaign_id', '=', '1'], ['id', 'IN', ['1']]]],
                ['AND', [['campaign_id', '=', '2'], ['id', 'IN', ['1', '2']]]]
            ]
        ]
    },
];

foreach my $test (@$FIXTURES) {
    my ($data, $error);
    try {
        $data = fields_to_filter($test->{'pk_fields'}, $test->{'data'}, for_db => $test->{'for_db'});
    }
    catch {
        $error = shift->message;
    };

    if ($test->{'error'}) {
        is($error, $test->{'error'}, $test->{'name'});
    } else {
        eq_or_diff($data, $test->{'expected'}, $test->{'name'});
    }
}
