#!/usr/bin/perl

use qbit;
use Test::Partner2::Simple;

use Test::More;
use Test::Differences qw(eq_or_diff);

use Utils::DomainBK qw( check_domains_for_absorption );

use Test::Deep qw(cmp_bag);

my %tests = (
    empty => {
        domains  => [qw()],
        expected => [qw()],
    },
    one_domain => {
        domains  => [qw(yandex.ru)],
        expected => [qw(yandex.ru)],
    },
    two_unrelated_domains => {
        domains  => [qw(google.com yandex.ru)],
        expected => [qw(google.com yandex.ru)],
    },
    domain_and_subdomain => {
        domains  => [qw(partner.yandex.ru yandex.ru)],
        expected => [qw(yandex.ru)],
    },
    more_subdomains => {
        domains  => [qw(jsonapi.partner.yandex.ru partner.yandex.ru yandex.ru)],
        expected => [qw(yandex.ru)],
    },
    more_subdomains_and_unrelated_domain => {
        domains  => [qw(yandex.ru partner.yandex.ru jsonapi.partner.yandex.ru google.com)],
        expected => [qw(yandex.ru google.com)],
    },
    non_ascii_domains => {
        domains  => [qw(россия.рф москва.россия.рф москва.рф)],
        expected => [qw(xn--80adxhks.xn--p1ai xn--h1alffa9f.xn--p1ai)],
    },
);

run_tests(
    sub {
        my ($app) = @_;

        foreach my $test_name (sort keys %tests) {
            my ($domains, $expected) = @{$tests{$test_name}}{qw(domains expected)};
            my @got = check_domains_for_absorption($domains);

            cmp_bag(\@got, $expected, $test_name);
        }
    },
    dont_create_database => 1
);
