use Test::More tests => 26;
use Test::Differences qw(eq_or_diff);
use Test::Exception;

use qbit;
use Utils::HookStash;

my $hook_stash_holder;

sub hook_stash {
    $hook_stash_holder //= Utils::HookStash->new();
}

throws_ok {hook_stash->get('test')} qr/Not inited/, 'not inited';

throws_ok {
    hook_stash->init(
        data => {once => 1},
        once => ['once']
    );
}
qr/once fields in data: once/, 'once fields in data';

throws_ok {
    hook_stash->init(
        once => ['once'],
        free => ['once']
    );
}
qr/once fields in free: once/, 'once fields in free';

throws_ok {
    hook_stash->init(unxepected => {});
}
qr/Unexpected fields in args: unxepected/, 'unxepected field';

my $stash;
lives_ok {
    $stash = hook_stash->init(
        data => {
            data => 1,
            base => {
                key  => 1,
                key2 => 2
            },
            patch => {
                key  => 10,
                key3 => 3
            }
        },
        once  => ['once'],
        free  => ['free'],
        mode  => 'test',
        merge => {settings => [qw(base patch)],},
    );
}
'create stash';

is hook_stash->get('data'), 1, 'get data';
throws_ok {hook_stash->set('data', 2)} qr/Cannot modify "data"/, 'cannot modify';

throws_ok {hook_stash->get('once')} qr/Cannot get "once"/, 'cannot get before assign';
lives_ok {hook_stash->set('once', 4)} 'assigned once';
is hook_stash->get('once'), 4, 'get assigned once';
throws_ok {hook_stash->set('once', 5)} qr/Cannot modify "once"/, 'cannot more assign once';

lives_ok {hook_stash->set('free', 4)} 'assigned free';
is hook_stash->get('free'), 4, 'get assigned free';

is hook_stash->check('nodata'), FALSE, 'check no data';
is hook_stash->check('free'),   TRUE,  'check has data';

is hook_stash->mode('test'), TRUE,  'right mode';
is hook_stash->mode('prod'), FALSE, 'wrong mode';

eq_or_diff(hook_stash->get('settings'), {key => 10, key2 => 2, key3 => 3}, 'get merged settings', {context => 1});

throws_ok {
    hook_stash->init(
        data => {once => 1},
        once => ['once']
    );
}
qr/Already inited/, 'already inited';

undef $stash;
throws_ok {hook_stash->get('free')} qr/Not inited/, 'not inited';

lives_ok {
    $stash = hook_stash->init(mode => ['test', 'dev']);
}
'create stash again';

is hook_stash->mode('test'), TRUE,  'right mode test';
is hook_stash->mode('dev'),  TRUE,  'right mode dev';
is hook_stash->mode('prod'), FALSE, 'wrong mode prod';
is hook_stash->mode('prod', 'test'), TRUE, 'right mode prod || test';

throws_ok {hook_stash->{data} = 6} qr/Not a HASH reference/, 'cannot access as hash';
