#!/usr/bin/perl -w

use Clone qw(clone);
use Test::More;    # tests => 1;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_path get_test_data_and_update_if_needed);

use qbit;
use Utils::JSON qw();

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $has = from_json readfile(get_test_data_path() . '/data.json');

        my $got = [];
        foreach my $test (@$has) {
            my ($old, $patch, $keys_transform) = @{$test}{qw( old patch keys_transform )};

            my $updated = Utils::JSON::apply_json_patch(clone($old), to_json($patch), $keys_transform);

            push @$got, {%$test, updated => $updated};
        }

        get_test_data_and_update_if_needed('data.json', $got);

        eq_or_diff($got, $has, 'apply_json_patch', {context => 5});
    },
);
